/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.standalone.rule;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.profiles.ProfileDefinition;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.utils.ValidationMessages;

public class StandaloneActiveRulesProvider
extends ProviderAdapter {
    private ActiveRules singleton = null;

    public ActiveRules provide(ProfileDefinition[] profileDefinitions) {
        if (this.singleton == null) {
            ActiveRulesBuilder builder = new ActiveRulesBuilder();
            ListMultimap<String, RulesProfile> profilesByLanguage = StandaloneActiveRulesProvider.profilesByLanguage(profileDefinitions);
            for (String language : profilesByLanguage.keySet()) {
                List<RulesProfile> defs = profilesByLanguage.get(language);
                StandaloneActiveRulesProvider.registerProfilesForLanguage(builder, language, defs);
            }
            this.singleton = builder.build();
        }
        return this.singleton;
    }

    private static void registerProfilesForLanguage(ActiveRulesBuilder builder, String language, List<RulesProfile> defs) {
        for (Map.Entry<String, Collection<RulesProfile>> entry : StandaloneActiveRulesProvider.profilesByName(defs).entrySet()) {
            String name = entry.getKey();
            if (!"Sonar way".equals(name)) continue;
            StandaloneActiveRulesProvider.registerProfile(builder, language, entry);
        }
    }

    private static void registerProfile(ActiveRulesBuilder builder, String language, Map.Entry<String, Collection<RulesProfile>> entry) {
        for (RulesProfile rp : entry.getValue()) {
            for (ActiveRule ar : rp.getActiveRules()) {
                NewActiveRule newAr = builder.create(RuleKey.of(ar.getRepositoryKey(), ar.getRuleKey())).setLanguage(language).setName(ar.getRule().getName()).setSeverity(ar.getSeverity().name()).setInternalKey(ar.getConfigKey()).setTemplateRuleKey(ar.getRule().getKey());
                for (ActiveRuleParam param : ar.getActiveRuleParams()) {
                    newAr.setParam(param.getKey(), param.getValue());
                }
                newAr.activate();
            }
        }
    }

    private static ListMultimap<String, RulesProfile> profilesByLanguage(ProfileDefinition[] profileDefinitions) {
        ArrayListMultimap<String, RulesProfile> byLang = ArrayListMultimap.create();
        for (ProfileDefinition definition : profileDefinitions) {
            ValidationMessages validation = ValidationMessages.create();
            RulesProfile profile = definition.createProfile(validation);
            if (profile == null || validation.hasErrors()) continue;
            byLang.put(StringUtils.lowerCase(profile.getLanguage()), profile);
        }
        return byLang;
    }

    private static Map<String, Collection<RulesProfile>> profilesByName(List<RulesProfile> profiles) {
        return Multimaps.index(profiles, new Function<RulesProfile, String>(){

            @Override
            public String apply(@Nullable RulesProfile profile) {
                return profile != null ? profile.getName() : null;
            }
        }).asMap();
    }
}

